/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.fabric.config;

import com.google.common.collect.Table;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.blay09.mods.balm.api.config.LoadedConfig;
import net.blay09.mods.balm.api.config.LoadedTableConfig;
import net.blay09.mods.balm.api.config.schema.BalmConfigSchema;
import net.blay09.mods.balm.fabric.config.FabricConfigSaver;
import net.blay09.mods.balm.notoml.Notoml;
import net.blay09.mods.balm.notoml.NotomlError;
import net.blay09.mods.balm.notoml.NotomlParser;
import net.minecraft.class_2960;
import org.slf4j.Logger;

public class FabricConfigLoader {
    private static final Logger logger = LogUtils.getLogger();

    public static LoadedConfig load(File configFile, BalmConfigSchema schema) throws IOException {
        Notoml notoml = new Notoml();
        if (configFile.exists()) {
            try {
                String input = Files.readString(configFile.toPath());
                notoml = NotomlParser.parse(input);
            }
            catch (IOException e) {
                logger.error("Failed to load config file {}", (Object)configFile, (Object)e);
            }
        }
        Table<String, String, Object> table = notoml.getProperties();
        Pair<LoadedTableConfig, List<Throwable>> configAndErrors = LoadedTableConfig.of(schema, table);
        LoadedTableConfig config = (LoadedTableConfig)configAndErrors.getFirst();
        for (Throwable throwable : (List)configAndErrors.getSecond()) {
            notoml.addError(new NotomlError(throwable.getMessage(), throwable));
        }
        if (notoml.hasErrors()) {
            logger.error("Errors were encountered when loading the config file {}:", (Object)configFile.getName());
            for (NotomlError error : notoml.getErrors()) {
                if (error.hasLine()) {
                    logger.error("- {} near line {}", new Object[]{error.getMessage(), error.getLine(), error.getCause()});
                    continue;
                }
                logger.error("- {}", (Object)error.getMessage(), (Object)error.getCause());
            }
            File backupFile = FabricConfigLoader.getBackupConfigFile(configFile);
            configFile.renameTo(backupFile);
            FabricConfigSaver.save(configFile, schema, config);
            logger.error("The affected properties have been reset to their defaults and a backup of the corrupted version was created under {}", (Object)backupFile.getName());
        } else {
            Notoml updated = FabricConfigSaver.toNotoml(schema, config);
            if (!notoml.containsProperties(updated)) {
                logger.info("The config file {} is missing some properties.", (Object)configFile.getName());
                File backupFile = FabricConfigLoader.getBackupConfigFile(configFile);
                configFile.renameTo(backupFile);
                FabricConfigSaver.save(configFile, schema, config);
                logger.info("The missing properties have been added and a backup of the previous version was created under {}", (Object)backupFile.getName());
            }
        }
        return config;
    }

    private static File getBackupConfigFile(File configFile) {
        File backupFile;
        int i = 1;
        do {
            backupFile = new File(configFile.getParentFile(), configFile.getName() + ".bak" + i);
            ++i;
        } while (backupFile.exists());
        return backupFile;
    }

    private static String getExpectedValueTypeMessage(Class<?> type, Class<?> innerType) {
        if (type == Integer.class || type == Integer.TYPE) {
            return "integer";
        }
        if (type == Long.class || type == Long.TYPE) {
            return "integer";
        }
        if (type == Double.class || type == Double.TYPE || type == Float.class || type == Float.TYPE) {
            return "floating point number";
        }
        if (type == Boolean.class || type == Boolean.TYPE) {
            return "boolean (true or false)";
        }
        if (type == String.class) {
            return "string";
        }
        if (type == class_2960.class) {
            return "resource location";
        }
        if (type == List.class) {
            return "list of " + FabricConfigLoader.getExpectedValueTypeMessage(innerType, null);
        }
        if (type == Set.class) {
            return "set of " + FabricConfigLoader.getExpectedValueTypeMessage(innerType, null);
        }
        if (Enum.class.isAssignableFrom(type)) {
            Enum[] enumConstants = (Enum[])type.getEnumConstants();
            return "enum value (" + String.join((CharSequence)", ", (CharSequence[])Arrays.stream(enumConstants).map(Enum::name).toArray(String[]::new)) + ")";
        }
        return null;
    }

    private static Object convertValue(Object value, Class<?> type, Class<?> innerType) {
        if (type == Integer.class || type == Integer.TYPE) {
            if (value instanceof Number) {
                return ((Number)value).intValue();
            }
            if (value instanceof String) {
                try {
                    return Integer.parseInt((String)value);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Invalid integer value: '" + String.valueOf(value) + "'", e);
                }
            }
        } else if (type == Long.class || type == Long.TYPE) {
            if (value instanceof Number) {
                return ((Number)value).longValue();
            }
            if (value instanceof String) {
                try {
                    return Long.parseLong((String)value);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Invalid integer value: '" + String.valueOf(value) + "'", e);
                }
            }
        } else if (type == Double.class || type == Double.TYPE) {
            if (value instanceof Number) {
                return ((Number)value).doubleValue();
            }
            if (value instanceof String) {
                String stringValue = (String)value;
                try {
                    return Double.parseDouble(stringValue.replace(',', '.'));
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Invalid floating point value: '" + String.valueOf(value) + "'", e);
                }
            }
        } else if (type == Float.class || type == Float.TYPE) {
            if (value instanceof Number) {
                return Float.valueOf(((Number)value).floatValue());
            }
            if (value instanceof String) {
                String stringValue = (String)value;
                try {
                    return Float.valueOf(Float.parseFloat(stringValue.replace(',', '.')));
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Invalid floating point value: '" + String.valueOf(value) + "'", e);
                }
            }
        } else {
            if (type == String.class) {
                if (value instanceof String) {
                    return value;
                }
                return value.toString();
            }
            if (type == class_2960.class) {
                if (value instanceof String) {
                    String stringValue = (String)value;
                    return class_2960.method_60654((String)stringValue);
                }
                return class_2960.method_60654((String)value.toString());
            }
            if (type == Boolean.class || type == Boolean.TYPE) {
                if (value instanceof Number) {
                    return ((Number)value).intValue() != 0;
                }
                if (value instanceof String) {
                    String stringValue = (String)value;
                    if (stringValue.equalsIgnoreCase("true")) {
                        return true;
                    }
                    if (stringValue.equalsIgnoreCase("false")) {
                        return false;
                    }
                    throw new IllegalArgumentException("Invalid boolean value: '" + String.valueOf(value) + "'");
                }
                if (value instanceof Boolean) {
                    return value;
                }
            } else {
                if (type == List.class) {
                    if (value instanceof List) {
                        List list = (List)value;
                        ArrayList<Object> convertedList = new ArrayList<Object>();
                        for (Object entry : list) {
                            Object convertedEntry = FabricConfigLoader.convertValue(entry, innerType, null);
                            if (convertedEntry == null) continue;
                            convertedList.add(convertedEntry);
                        }
                        return convertedList;
                    }
                    if (value.getClass() == innerType) {
                        ArrayList<Object> list = new ArrayList<Object>();
                        list.add(value);
                        return list;
                    }
                    throw new IllegalArgumentException("Invalid list value: '" + String.valueOf(value) + "'");
                }
                if (type == Set.class) {
                    if (value instanceof Collection) {
                        Collection collection = (Collection)value;
                        HashSet<Object> convertedSet = new HashSet<Object>();
                        for (Object entry : collection) {
                            Object convertedEntry = FabricConfigLoader.convertValue(entry, innerType, null);
                            if (convertedEntry == null) continue;
                            convertedSet.add(convertedEntry);
                        }
                        return convertedSet;
                    }
                    if (value.getClass() == innerType) {
                        HashSet<Object> list = new HashSet<Object>();
                        list.add(value);
                        return list;
                    }
                    throw new IllegalArgumentException("Invalid list value: '" + String.valueOf(value) + "'");
                }
                if (Enum.class.isAssignableFrom(type)) {
                    if (value instanceof String) {
                        try {
                            return FabricConfigLoader.parseEnumValue(type, (String)value);
                        }
                        catch (IllegalArgumentException e) {
                            throw new IllegalArgumentException("Invalid enum value: '" + String.valueOf(value) + "'", e);
                        }
                    }
                    throw new IllegalArgumentException("Invalid enum value: '" + String.valueOf(value) + "'");
                }
            }
        }
        return null;
    }

    private static Object parseEnumValue(Class<?> type, String value) {
        for (Object enumConstant : type.getEnumConstants()) {
            if (!enumConstant.toString().equalsIgnoreCase(value)) continue;
            return enumConstant;
        }
        return null;
    }
}

